<?php

namespace GoDaddy\WordPress\MWC\Common\Repositories\WooCommerce;

use Exception;
use GoDaddy\WordPress\MWC\Common\Repositories\WooCommerceRepository;
use WC_Order;

/**
 * Repository for handling WooCommerce orders.
 *
 * @since 3.4.1
 */
class OrdersRepository
{
    /**
     * Gets a WooCommerce order object.
     *
     * @param int order ID
     * @return WC_Order|null
     * @throws Exception
     */
    public static function get(int $id)
    {
        if (! WooCommerceRepository::isWooCommerceActive()) {
            return null;
        }

        return wc_get_order($id) ?: null;
    }

    /**
     * Gets a list of WooCommerce statuses which are considered "paid".
     *
     * @since 3.4.1
     *
     * @return string[] array of status slugs
     */
    public static function getPaidStatuses() : array
    {
        return (array) wc_get_is_paid_statuses();
    }
}
