<?php

namespace GoDaddy\WordPress\MWC\Core\Payments\Poynt\Events\Subscribers;

use GoDaddy\WordPress\MWC\Common\Configuration\Configuration;
use GoDaddy\WordPress\MWC\Common\Events\Contracts\EventContract;
use GoDaddy\WordPress\MWC\Common\Events\Contracts\SubscriberContract;
use GoDaddy\WordPress\MWC\Common\Helpers\ArrayHelper;
use GoDaddy\WordPress\MWC\Core\Payments\Poynt\Events\PoyntStoreDeviceFirstActivatedEvent;
use GoDaddy\WordPress\MWC\Core\Sync\Jobs\PushSyncJob;
use GoDaddy\WordPress\MWC\Core\WooCommerce\Payments\Events\PaymentGatewayConnectedEvent;

class RegisterWebhooksSubscriber implements SubscriberContract
{
    /** @var array */
    const WEBHOOK_TOPICS = [
        'ORDER_CANCELLED',
        'ORDER_COMPLETED',
        'ORDER_UPDATED',
        'TRANSACTION_AUTHORIZED',
        'TRANSACTION_CAPTURED',
        'TRANSACTION_REFUNDED',
        'TRANSACTION_UPDATED',
        'TRANSACTION_VOIDED',
    ];

    /**
     * Determines whether the event should be handled.
     *
     * @param EventContract $event
     * @return bool
     * @throws \Exception
     */
    public function shouldHandle(EventContract $event) : bool
    {
        return Configuration::get('features.bopit', false)
               && (
                   // register webhooks when connected to GDP for the first time
                   ($event instanceof PaymentGatewayConnectedEvent
                    && ArrayHelper::get($event->getData(), 'paymentGateway.id') == 'poynt')
                   ||
                   // maybe register webhooks when the first Poynt smart terminal is activated (for sites already previously connected)
                   $event instanceof PoyntStoreDeviceFirstActivatedEvent
               );
    }

    /**
     * Handles the event.
     *
     * @param EventContract $event
     * @throws Exception
     * @return void
     */
    public function handle(EventContract $event)
    {
        if (! $this->shouldHandle($event)) {
            return;
        }

        $this->maybeRegisterWebhooksJob();
    }

    /**
     * Schedule job to register Poynt webhooks, if not already registered.
     */
    protected function maybeRegisterWebhooksJob()
    {
        if (get_option('mwc_payments_poynt_onboarding_webhooksRegistered')) {
            return;
        }

        PushSyncJob::create([
            'owner'      => 'register_poynt_webhooks',
            'batchSize'  => count(static::WEBHOOK_TOPICS),
            'objectType' => 'webhooks',
            'objectIds'  => static::WEBHOOK_TOPICS,
        ]);
    }
}
