<?php

namespace GoDaddy\WordPress\MWC\Core\Features\EmailNotifications\Events;

use GoDaddy\WordPress\MWC\Common\Events\Contracts\EventBridgeEventContract;
use GoDaddy\WordPress\MWC\Common\Traits\IsEventBridgeEventTrait;
use GoDaddy\WordPress\MWC\Core\Features\EmailNotifications\Contracts\EmailNotificationContract;

abstract class AbstractEmailNotificationEvent implements EventBridgeEventContract
{
    use IsEventBridgeEventTrait;

    /** @var EmailNotificationContract */
    protected $emailNotification;

    /**
     * Constructor.
     *
     * @param EmailNotificationContract $emailNotification
     */
    public function __construct(EmailNotificationContract $emailNotification)
    {
        $this->resource = 'email-notification';
        $this->emailNotification = $emailNotification;
    }

    /**
     * Gets the event assigned Email Notification.
     *
     * @return EmailNotificationContract
     */
    public function getEmailNotification() : EmailNotificationContract
    {
        return $this->emailNotification;
    }

    /**
     * Gets the data for the current event.
     *
     * @return array
     */
    public function getData() : array
    {
        return [
            'email_label'  => $this->getEmailNotification()->getLabel(),
            'email_type'   => $this->getEmailCategory(),
            'email_status' => $this->getEmailStatus(),
        ];
    }

    /**
     * Gets the email notification category (first finding).
     *
     * @return string|null
     */
    protected function getEmailCategory()
    {
        $emailCategories = $this->getEmailNotification()->getCategories();

        return $emailCategories ? array_shift($emailCategories) : null;
    }

    /**
     * Gets the email notification status: "enabled" or "disabled" or "manual".
     *
     * @return string
     */
    protected function getEmailStatus() : string
    {
        // is email manually triggered?
        if ($this->getEmailNotification()->isManual()) {
            return 'manual';
        }

        // is email enabled or not?
        return $this->getEmailNotification()->isEnabled() ? 'enabled' : 'disabled';
    }
}
